package com.td2.example.demo2.control.exceptions;

import com.td2.example.demo2.commons.ErrorList;

public class ResourceNotFoundException extends RuntimeException {

    /* NB: in order to build a request answer to the http request that is of format :
    { errorNumber: ..., context: ..., message: ...}, this class dcalres two attributes
    that represent the error number and the context, i.e. the operation that yielded an error
     */
    protected Integer errorNumber;
    protected String context;

    public ResourceNotFoundException(Integer errorNumber, String context, String message) {
        super(message);
        this.errorNumber = errorNumber;
        this.context = context;
    }

    public ResourceNotFoundException(String context) {
        this(ErrorList.RESOURCE_NOT_FOUND, context, ErrorList.getMessage(ErrorList.RESOURCE_NOT_FOUND));
    }

    public ResourceNotFoundException() {
        this(ErrorList.RESOURCE_NOT_FOUND, "", ErrorList.getMessage(ErrorList.RESOURCE_NOT_FOUND));
    }

    public Integer getErrorNumber() {
        return errorNumber;
    }

    public String getContext() {
        return context;
    }
}
