package com.td2.example.demo2.control;

import com.td2.example.demo2.control.exceptions.CSVConversionException;
import com.td2.example.demo2.control.exceptions.ResourceNotFoundException;
import com.td2.example.demo2.model.DTO.ErrorDTO;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerAdvice {

    // NB: even if this is an exception handler for the ResourceNotFoundException, it is able
    // to manage exceptions of ResourceNotFoundException subclasses, as HeroNotFoundException
    @ExceptionHandler(ResourceNotFoundException.class)
    @ResponseStatus(HttpStatus.NOT_FOUND)
    ErrorDTO resourceNotFoundHandler(ResourceNotFoundException ex) {
        return new ErrorDTO(ex.getErrorNumber(), ex.getContext(), ex.getMessage());
    }

    @ExceptionHandler(CSVConversionException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    ErrorDTO csvConversionHandler(CSVConversionException ex) {
        return new ErrorDTO(ex.getErrorNumber(), ex.getContext(), ex.getMessage());
    }
}
