package com.td2.example.demo1.repository;

import com.td2.example.demo1.model.Hero;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;
import java.util.Optional;

public interface HeroesRepository extends JpaRepository<Hero, Long> {

    // NB : no need to implement methods below : spring will do it automatically inferring it from their names !!

    /* findByPublicName() returns an Optional, as for findById().
        This is unnecessary, but useful to have the same behavior in all services.
        Instead, this method could return directly a Hero, which should be null if not found.
        It would imply to modify services using this method, to check whether it returns
        null or not.
     */
    Optional<Hero> findByPublicName(String publicName);

    List<Hero> findAllByPower(String power);
    List<Hero> findAllByPowerContaining(String pattern);

}
