package com.td2.example.demo1.model;

import jakarta.persistence.*;

@Entity
@Table(name = "heroes")
public class Hero {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Long id;

    // using @Column just to illustrate its possible uses.
    @Column(name="publicname", nullable = false, unique = true, length = 50)
    private String publicName;
    // BdD name will be by default real_name
    private String realName;
    private String power;
    // BdD name will be by default power_level
    private int powerLevel;

    public Hero() {}

    public Hero(Long id, String publicName, String realName, String power, int powerLevel) {
        this.id = id;
        this.publicName = publicName;
        this.realName = realName;
        this.power = power;
        this.powerLevel = powerLevel;
    }

    public Hero(String publicName, String realName, String power, int powerLevel) {
        this.publicName = publicName;
        this.realName = realName;
        this.power = power;
        this.powerLevel = powerLevel;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPublicName() {
        return publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getPower() {
        return power;
    }

    public void setPower(String power) {
        this.power = power;
    }

    public int getPowerLevel() {
        return powerLevel;
    }

    public void setPowerLevel(int powerLevel) {
        this.powerLevel = powerLevel;
    }

    @Override
    public String toString() {
        return "Hero{" +
                "id=" + id +
                ", publicName='" + publicName + '\'' +
                ", realName='" + realName + '\'' +
                ", power='" + power + '\'' +
                ", powerLevel=" + powerLevel +
                '}';
    }
}
