package com.td2.example.demo2;


import com.td2.example.demo2.model.Hero;
import com.td2.example.demo2.service.CSVService;
import com.td2.example.demo2.service.HeroesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Component
public class MyRunner implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(MyRunner.class);

    private final HeroesService heroesService;
    private final CSVService csvService;

    // the input file within resources directory
    @Value("classpath:heroes.csv")
    Resource resourceFile;

    @Autowired
    public MyRunner(HeroesService heroesService, CSVService csvService) {
        this.heroesService = heroesService;
        this.csvService = csvService;
    }
    @Override
    @Transactional
    public void run(String... args) throws Exception {

        logger.info("initializing heroes");

        // read csv resource file
        csvService.saveCSVToHeroes(resourceFile);
        // check if ok by getting/printing all heroes to console
        List<Hero> list = heroesService.findAll();
        for(Hero h : list) {
            System.out.println(h);
        }

    }
}
