package com.td1.example.demo2.service;

import com.td1.example.demo2.model.Hero;
import com.td1.example.demo2.repository.HeroesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class HeroesService {
    private HeroesRepository heroesRepository;

    @Autowired
    public HeroesService(HeroesRepository heroesRepository) {
        this.heroesRepository = heroesRepository;
    }

    public List<Hero> findAll() {
        System.out.println("Getting all heroes");
        List<Hero> list = heroesRepository.findAll();
        return list;
    }


    public Hero findHeroByPublicName(String publicName) {
        System.out.println("Getting hero by public name: " + publicName);
        Hero hero = heroesRepository.findHeroByPublicName(publicName);
        return hero;
    }

    public List<Hero> findAllByPower(String power) {
        System.out.println("Getting heroes with power " + power);
        List<Hero> list = heroesRepository.findAllByPower(power);
        return list;
    }

    public List<Hero> findAllByPowerContaining(String pattern) {
        System.out.println("Getting heroes with power containing " + pattern);
        List<Hero> list = heroesRepository.findAllByPowerContaining(pattern);
        return list;
    }

    public long count() {
        long count = heroesRepository.count();
        return count;
    }

}
