package com.td1.example.demo2;

import com.td1.example.demo2.model.Hero;
import com.td1.example.demo2.repository.HeroesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class MyRunner implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(MyRunner.class);

    private final HeroesRepository heroesRepository;

    @Autowired
    public MyRunner(HeroesRepository heroesRepository) {
        this.heroesRepository = heroesRepository;
    }

    @Override
    public void run(String... args) throws Exception {

        // add a new hero, using a entity instance
        Hero phil = new Hero("stickman", "phil deferre", "superthin", 99);
        heroesRepository.save(phil);

        logger.info("getting all heroes");
        List<Hero> list = heroesRepository.findAll();
        for(Hero h : list) {
            System.out.println(h);
        }
    }
}
