package com.td1.example.demo2.model;

import jakarta.persistence.*;

@Entity
@Table(name = "heroes")
public class Hero {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Long id;

    private String publicName;
    private String realName;
    private String power;
    private int powerLevel;

    public Hero() {}

    public Hero(Long id, String publicName, String realName, String power, int powerLevel) {
        this.id = id;
        this.publicName = publicName;
        this.realName = realName;
        this.power = power;
        this.powerLevel = powerLevel;
    }

    public Hero(String publicName, String realName, String power, int powerLevel) {
        this.publicName = publicName;
        this.realName = realName;
        this.power = power;
        this.powerLevel = powerLevel;
    }

    public String getPublicName() {
        return publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getPower() {
        return power;
    }

    public void setPower(String power) {
        this.power = power;
    }

    public int getPowerLevel() {
        return powerLevel;
    }

    public void setPowerLevel(int powerLevel) {
        this.powerLevel = powerLevel;
    }

    @Override
    public String toString() {
        return "Hero{" +
                "id=" + id +
                ", publicName='" + publicName + '\'' +
                ", realName='" + realName + '\'' +
                ", power='" + power + '\'' +
                ", powerLevel=" + powerLevel +
                '}';
    }
}
