package com.td1.example.demo2.control;

import com.td1.example.demo2.model.Hero;
import com.td1.example.demo2.service.HeroesService;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
public class HeroesController {

    private final HeroesService heroesService;

    HeroesController(HeroesService heroesService) {
        this.heroesService = heroesService;
    }

    @GetMapping("/heroes")
    public List<Hero> getAllHeroes() {
        System.out.println("Getting all heroes");
        List<Hero> list = heroesService.findAll();
        return list;
    }


    @GetMapping("/heroes/getbypublicname/{name}")
    public Hero getHeroByPublicName(@PathVariable String name ) {
        System.out.println("Getting hero by public name: " + name);
        Hero hero = heroesService.findHeroByPublicName(name);
        return hero;
    }

    @GetMapping("/heroes/getbypower")
    public List<Hero> getHeroesByPower(@RequestParam String power, @RequestParam(required = false) Boolean pattern) {
        List<Hero> list = null;
        if ((pattern == null) || (pattern == false)) {
            System.out.println("Getting heroes with power " + power);
            list = heroesService.findAllByPower(power);
        }
        else {
            list = heroesService.findAllByPowerContaining(power);
        }
        return list;
    }

    @GetMapping("/heroes/count")
    public long getItemsCount() {
        System.out.println("Getting number of heroes");
        long count = heroesService.count();
        return count;
    }
}
