/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionId;

public final class ConnectionCheckedOutEvent {
    private final ConnectionId connectionId;
    private final long operationId;

    public ConnectionCheckedOutEvent(ConnectionId connectionId, long operationId) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.operationId = operationId;
    }

    @Deprecated
    public ConnectionCheckedOutEvent(ConnectionId connectionId) {
        this(connectionId, -1L);
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getOperationId() {
        return this.operationId;
    }

    public String toString() {
        return "ConnectionCheckedOutEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", operationId=" + this.operationId + '}';
    }
}

