import java.io.*;
import java.net.*;
import java.util.*;

class ThreadServer extends Thread {

	BufferedReader br;
	PrintStream ps;
	Socket sock;
	ServerData data;
	int idClient;

	public ThreadServer(int idClient, Socket sock, ServerData data) {
		this.sock = sock;
		this.idClient = idClient;
		this.data = data;
	}

	public void run() {
		System.out.println("starting thread "+idClient);

		try {
			br = new BufferedReader(new InputStreamReader(sock.getInputStream()));
			ps = new PrintStream(sock.getOutputStream());
			// sending to the client its id
			ps.println(idClient);
		}
		catch(IOException e) {
			System.err.println("Thread "+idClient+": cannot create streams. Aborting.");
			return;
		}
		// create list for idClient
		data.newClient(idClient);
		requestLoop();

		System.out.println("end of thread "+idClient);
	}

	public void requestLoop() {

		String req = "";
		String[] reqParts;
		String numReq = "";
		String idStr = "";
		int id = -1;
		try {

			while(true) {
				req = br.readLine();
				if (req == null) { // violent close from client
					break;
				}
				else if (req == "") { // explicit close
					break;
				}
				reqParts = req.split(" ");
				if (reqParts.length == 1) {
					ps.println("ERR no client id is provided");
					continue;
				}
				//testing id sent by client

				boolean err = false;
				try {
					id = Integer.parseInt(reqParts[1]);
				}
				catch(NumberFormatException e) {
					err = true;
				}

				if ((err) || (!data.exists(id))) {
					ps.println("ERR invalid client id");
					continue;
				}

				if ("1".equals(reqParts[0])) {
					if (reqParts.length != 5) {
						ps.println("ERR wrong number of parameters");
					}
					else {
						requestStoreData(id, reqParts[2], reqParts[3], reqParts[4]);
					}
				}
			}
			System.out.println("end of request loop");
		}
		catch(IOException e) {
			System.out.println("problem with receiving request: "+e.getMessage());
		}
	}

	protected void requestStoreData(int id, String param1, String param2, String param3) throws IOException {
		System.out.println("Thread ["+idClient+"]: processing request STORE DATA");

		boolean err = false;
		double temperature=0,humidity=0,pressure=0;

		try {
			temperature = Double.parseDouble(param1);
			humidity = Double.parseDouble(param2);
			pressure = Double.parseDouble(param3);
		}
		catch(NumberFormatException e) {
			err = true;
		}

		if (err) {
			ps.println("ERR invalid or wrong number of paramaters");
			return;
		}

		data.addData(id, temperature, humidity, pressure);
		ps.println("OK");
	}

}

		
