import java.io.*;
import java.net.*;

class ClientTCPDiamond {

	Socket sockComm;
	PrintStream ps;
	BufferedReader br;
	BufferedReader consoleIn; // keyboard readings
	int idPlayer; // sent by the server after accepting pseudo and = to 0 or 1

	public ClientTCPDiamond(String serverIp, int serverPort) throws IOException {

		sockComm = new Socket(serverIp, serverPort);
		ps = new PrintStream(sockComm.getOutputStream());
		br = new BufferedReader(new InputStreamReader(sockComm.getInputStream()));
		consoleIn = new BufferedReader(new InputStreamReader(System.in));
	}

	private void stopParty() {
		System.out.println("Party is over because of a network disconnection");
		System.exit(0);
	}

	public void mainLoop() throws IOException {
		String line = null;

		// 0 - check if client can go further
		line = br.readLine();
		if (!"OK".equals(line)) {
			System.out.println("Party already started. Try again later");
			return;
		}
		// 1 - send the pseudo
		setPseudo();

		// 2 - check if pseudo is registered
		line = br.readLine();
		if (!"OK".equals(line)) {
			System.out.println("Party already started. Try again later");
			return;
		}
		partyLoop();
	}

	private void setPseudo() throws IOException {

		String line = null;
		String[] lineParts = null;
		boolean ok = false;

		while (!ok) {
			System.out.print("Enter your pseudo: ");
			line = consoleIn.readLine();
			if (line == null) {
				System.out.println("Quit the game");
				System.exit(0);
			}
			else if (!line.isEmpty()) {
				ps.println(line);
				line = br.readLine();
				lineParts = line.split(" ");
				if ("OK".equals(lineParts[0])) {
					ok = true;
				}
				else if ("PSEUDO".equals(lineParts[1])) {
					System.out.println("This pseudo already exists. Try another one");
				}
			} else {
				System.out.println("Invalid pseudo.");
			}
		}
	}

	private void partyLoop() throws IOException {

		String line = null;
		String[] lineParts = null;
		boolean stop = false;
		int nbTurn = 0;
		String advName = "";
		int currentPlayer = -1;
		int pawnValue = 0;
		boolean valid = false;

		// 0 - receive my id
		line = br.readLine();
		if (line == null) stopParty();
		System.out.println("my id is "+line);
		idPlayer = Integer.parseInt(line);

		while (!stop) {
			// start a new turn

			// 1 - receive the current visual of the board
			for(int i=0;i<6;i++) {
				line = br.readLine();
				if (line == null) stopParty();
				System.out.println(line);
			}

			// 2 - read the current player id and the value of the pawn to play
			line = br.readLine();
			if (line == null) stopParty();
			currentPlayer = Integer.parseInt(line);

			// 3 - if I am the current player
			if (idPlayer == currentPlayer) {
				System.out.println("It is your turn to play");
				// 3.1 - receive pawn value to play
				line = br.readLine();
				if (line == null) stopParty();
				pawnValue = Integer.parseInt(line);
				// 3.2 - send what to play, until it is valid
				valid = false;
				while (!valid) {
					System.out.print("choose a cell to play pawn " + pawnValue + " : ");
					line = consoleIn.readLine();
					if (line == null) stopParty();
					ps.println(line); // sending to the server
					line = br.readLine(); // reading ok or error
					if (line == null) stopParty();
					if ("OK".equals(line)) {
						valid = true;
					} else {
						System.out.println("ERROR ! invalid cell");
					}
				}
			}
			else {
				System.out.println("Waiting for the other player to play...");
			}
			// 4 - receiving party state
			line = br.readLine();
			if (line == null) stopParty();
			lineParts = line.split(" ");
			// if party is at end
			if ("END".equals(lineParts[0])) {
				// receive one last time the visual of the board
				for(int i=0;i<6;i++) {
					line = br.readLine();
					if (line == null) stopParty();
					System.out.println(line);
				}
				int blueScore = Integer.parseInt(lineParts[1]);
				int redScore = Integer.parseInt(lineParts[2]);
				if (blueScore < redScore) {
					System.out.println("Winner is blue player");
				}
				else if (blueScore > redScore) {
					System.out.println("Winner is red player");
				}
				else {
					System.out.println("Draw party");
				}
				stop = true;
			}
		}
	}
}