/**
 * creates and exports PowerSchema
 * @module PowerSchema
 */

const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const Config = require('../../commons/config');

let PowerSchema = new Schema({
    name: {type: String, required: true},
    type: { type: Number,required: true, enum: [ Config.POWER_STRENGTH,Config.POWER_SPEED,Config.POWER_STAMINA,Config.POWER_MAGIC,Config.POWER_SCARY,Config.POWER_STUPID, Config.POWER_STEALTH] },
    level: {type: Number, required: true, min:Config.POWER_LEVEL_MIN, max:Config.POWER_LEVEL_MAX}
},{versionKey: false});

module.exports = PowerSchema;
