const Config = require("./config");
const ERR_AUTH_LOGIN_NOT_DEFINED = 1000;
const ERR_AUTH_PASSWORD_NOT_DEFINED = 1001;

const ERR_AUTH_NO_JWT_TOKEN = 1020;
const ERR_AUTH_NO_XSRF_TOKEN = 1021;
const ERR_AUTH_NOT_AUTHORIZED = 1022;
const ERR_AUTH_TOKEN_EXPIRED = 1023;
const ERR_AUTH_PASSWORD_NO_MATCH = 1029;

const ERR_AUTH_CANNOT_CREATE_REFRESHTOKEN = 1024;
const ERR_AUTH_NO_REFRESH_TOKEN = 1025;
const ERR_AUTH_REFRESH_NO_MATCH = 1026;
const ERR_AUTH_REFRESH_EXPIRED = 1027;
const ERR_AUTH_INVALID_FIND_REFRESHTOKEN_REQUEST = 1028;

const ERR_AUTH_INVALID_SESSIONID = 1030;
const ERR_AUTH_SESSIONID_NOT_DEFINED = 1031;



const authErrors = [
  { number: ERR_AUTH_LOGIN_NOT_DEFINED, status: 400, message:  { en: '', fr:  'le login de l\'utilisateur n\'est pas défini ou invalide' }},
  { number: ERR_AUTH_PASSWORD_NOT_DEFINED, status: 400, message:  { en: '', fr:  'le mot de passe de l\'utilisateur n\'est pas défini ou invalide' }},
  { number: ERR_AUTH_NO_JWT_TOKEN, status: 400, message:  { en: '', fr:  'aucun token jwt n\'est fourni' }},
  { number: ERR_AUTH_NO_XSRF_TOKEN, status: 400, message:  { en: '', fr:  'aucun token xsrf n\'est fourni' }},
  { number: ERR_AUTH_NOT_AUTHORIZED, status: 401, message:  { en: '', fr:  'token jwt invalide: autorisation refusée' }},
  { number: ERR_AUTH_TOKEN_EXPIRED, status: 401, message:  { en: '', fr:  'le token jwt fourni a expiré' }},
  { number: ERR_AUTH_PASSWORD_NO_MATCH, status: 401, message:  { en: '', fr:  'le mot de passe fourni est invalide' }},
  { number: ERR_AUTH_CANNOT_CREATE_REFRESHTOKEN, status: 400, message:  { en: '', fr:  'impossible de créer un token de rafraichissement' }},
  { number: ERR_AUTH_NO_REFRESH_TOKEN, status: 400, message:  { en: '', fr:  'aucun token de rafraichissement n\'est fourni' }},
  { number: ERR_AUTH_REFRESH_NO_MATCH, status: 403, message:  { en: '', fr:  'impossible de trouver le token de rafraichissement' }},
  { number: ERR_AUTH_REFRESH_EXPIRED, status: 401, message:  { en: '', fr:  'le token de rafraichissement fourni a expiré' }},
  { number: ERR_AUTH_INVALID_FIND_REFRESHTOKEN_REQUEST, status: 400, message:  { en: '', fr:  'requête de recherche d\'un token de rafraichissement invalide' }},
  { number: ERR_AUTH_INVALID_SESSIONID, status: 400, message: { en: 'invalid session id, user must log again', fr: 'l\'identifiant de session est invalide. L\'utilisateur doit se reloguer' }},
  { number: ERR_AUTH_SESSIONID_NOT_DEFINED, status: 404, message: { en: 'the request does not contains a session id', fr: 'la requête ne contient pas d\'identifiant de session' }},

];

const getError = (number, lang) => {
  if (lang === undefined) lang = Config.defaultLang;
  let err = authErrors.find(e => e.number === number);
  if (err !== undefined) {
    if (lang === 'en') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.en
      };
    }
    else if (lang === 'fr') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.fr
      };
    }
  }
  return {
    error: 1,
    status: 500,
    data: 'undetermined error'
  }
};

module.exports = {
  ERR_AUTH_LOGIN_NOT_DEFINED,
  ERR_AUTH_PASSWORD_NOT_DEFINED,
  ERR_AUTH_NO_JWT_TOKEN,
  ERR_AUTH_NO_XSRF_TOKEN,
  ERR_AUTH_NOT_AUTHORIZED,
  ERR_AUTH_TOKEN_EXPIRED,
  ERR_AUTH_PASSWORD_NO_MATCH,
  ERR_AUTH_CANNOT_CREATE_REFRESHTOKEN,
  ERR_AUTH_INVALID_FIND_REFRESHTOKEN_REQUEST,
  ERR_AUTH_NO_REFRESH_TOKEN,
  ERR_AUTH_REFRESH_EXPIRED,
  ERR_AUTH_REFRESH_NO_MATCH,
  ERR_AUTH_INVALID_SESSIONID,
  ERR_AUTH_SESSIONID_NOT_DEFINED,
  getError
};


