/**
 * assgins routes
 * @module apiRoute
 */

const express = require('express');
const router = express.Router();

// Require the controllers WHICH WE DID NOT CREATE YET!!
const heroController = require('../controllers/herocorp/hero.controller');
const organizationController = require('../controllers/herocorp/organization.controller');
const teamController = require('../controllers/herocorp/team.controller')
const authController = require('../controllers/auth/auth.controller');

/* a simple function that allows an async controller
   to be protected against uncaught exceptions.
   It supposes that an error handler is setup
 */
const errorGuard = ctrl =>
  (req, res, next) => {
    Promise.resolve(ctrl(req, res, next))
      .catch(next);
  };

// heroes routes
router.post('/heroes/create', errorGuard(heroController.create));
router.put('/heroes/update', errorGuard(heroController.update));
router.put('/heroes/authupdate', authController.verifyToken, errorGuard(heroController.authUpdate));
router.get('/heroes/getaliases', errorGuard(heroController.getAliases)); // get only the public name of all heroes
router.get('/heroes/getbyid/:id', errorGuard(heroController.getById));

// teams routes
router.post('/teams/create', errorGuard(teamController.create));
router.get('/teams/get', errorGuard(teamController.getAll));
router.patch('/teams/addheroes', errorGuard(teamController.addHeroes));
router.patch('/teams/removeheroes', errorGuard(teamController.removeHeroes));

// organizations routes
router.post('/orgs/create', errorGuard(organizationController.create));
router.get('/orgs/getbyid/:id', errorGuard(organizationController.getById));
router.get('/orgs/get', errorGuard(organizationController.getAll));
router.patch('/orgs/addteam', errorGuard(organizationController.addTeam));
router.patch('/orgs/removeteam', errorGuard(organizationController.removeTeam));

module.exports = router;
