const express = require('express');
const router = express.Router();

const userController = require('../controllers/auth/user.controller');
const authController = require('../controllers/auth/auth.controller');

const errorGuard = ctrl =>
  (req, res, next) => {
    Promise.resolve(ctrl(req, res, next))
      .catch(next);
  };


router.get('/user/getuser/:login', authController.verifyToken, errorGuard(userController.getUser));
router.post('/user/register', errorGuard(userController.createUser));
router.post('/auth/signin', errorGuard(authController.signIn));
router.patch('/auth/refresh', errorGuard(authController.refreshToken))

module.exports = router;
