/**
 * creates and exports OrganizationSchema
 * @module OrganizationSchema
 */
const mongoose = require('mongoose');
const Schema = mongoose.Schema;
/* IMPORTANT: from a design point of view, the essential question is :
   Is the team an array of Hero subdocuments (sol. 1) or just references to
   _id of documents in Hero collection (sol. 2) ?

   sol. 1 pro: since a hero won't be affiliated to many organizations, there won't be
   a lot of duplicated hero in the Organization collection.
   sol 1. big cons: if we need to modify a hero, we need to search for its name in all organizations
   and to modify each occurrence. If hero modifications are frequent, it would be a waste of time.

   sol. 2 pro:
    - hero modifications are made on a single document.
    - a hero can be created without being affiliated to an organization.
   sol. 2 minor cons: it is quite similar to an sql approach, with a kind of join
   to get an organization document with team field fulfilled with the heroes. If the DB
   would contain a lot of organizations with a lot of heroes, it would be more time consuming
   than sol. 1
 */

let OrganizationSchema = new Schema({
  name: {type:String, required:true},
  secret: {type:String, required:true},
  teams: [{type: Schema.Types.ObjectId, ref: 'Team'}],
},{versionKey: false});

module.exports = OrganizationSchema;
