/**
 * creates and exports HeroSchema
 * @module HeroSchema
 */

const mongoose = require('mongoose');
const Schema = mongoose.Schema;

/* NB: powers will be an array of subdocument, so we need to import
  the schema.
 */
const PowerSchema = require('./power.schema')
/* NB: organization is not stored as a subdocument, but only
  as a reference to the _id of an existing document in the
  Organization collection. So we need to import the model
 */
//const Organization = require('./organization.model')

let HeroeSchema = new Schema({
  publicName: {type: String, required: true},
  realName: {type: String},
  powers: [ PowerSchema ],
  // NB : a hero may be affiliated to several teams (see team.schema)
},{versionKey: false});


module.exports = HeroeSchema;
