/**
 * defines methods to interact with Hero documents
 * @module TeamController
 */
const Team = require('../../models/herocorp/team.model')
const TeamErrors = require('../../commons/team.errors')
const Hero = require('../../models/herocorp/heroe.model');
const Organization = require ('../../models/herocorp/organization.model')

const {answer} =  require('../ControllerAnswer')

const create = async function (req, res, next) {
  answer.reset()
  console.log('create team with req.body = '+JSON.stringify(req.body));
  // sanity check on required parameters
  if (!req.body.name) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_CREATE_INVALID_DATA))
    return next(answer);
  }
  // search if name already exists (nb: syntax using exec(), await and try/catch)
  try {
    let team = await Team.findOne({name: req.body.name}).exec()
    if (team !== null) {
      answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_CREATE_ALREADY_EXISTS))
      return next(answer);
    }
  }
  catch(err) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_CREATE_FAILED))
    return next(answer);
  }

  // make an object with required fields
  let t = {
    name: req.body.name,
    members: []
  };

  //insert the hero in DB (nb: create() uses callbacks and not await/exec)
  Team.create(t, function(err, org) {
    if (err) {
      answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_CREATE_FAILED))
      return next(answer);
    }
    if (org === null) {
      answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_CREATE_FAILED))
      return next(answer);
    }
    else {
      // sends back the whole org
      answer.setPayload(org)
      res.status(201).send(answer);
    }
  });
};

const update = async function (req, res, next) {
  answer.reset();
  console.log('update a team');

  answer.setPayload("update not implemented yet")
  res.status(200).send(answer);
};

/*
  req.body.idHeroes is an array of _id
  req.body.idTeam is the _id of the affiliation team.
 */
const addHeroes = async function (req, res, next) {

  answer.reset();
  console.log('add heroes to a team');
    if ((!req.body.idHeroes) || (!req.body.idTeam)) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_ADDHEROES_INVALID_DATA))
    return next(answer);
  }

  // check if all _id in req.body.heroes exist. If not => error
  let heroes = [];
  let hero = null
  for(let i=0;i<req.body.idHeroes.length;i++) {
    try {
      hero = await Hero.findOne({_id: req.body.idHeroes[i]}).exec()
	if (hero === null) {
	//    console.log("cannot find id hero : "+req.body.idHeroes[i]);
        answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_ADDHEROES_INVALID_DATA))
        return next(answer);
	}
	console.log("found id hero "+req.body.idHeroes[i]);
      heroes.push(hero)
    } catch (err) {
      answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_ADDHEROES_FAILED))
      return next(answer);
    }
  }
  //  console.log(heroes);
  // check if team with an _id = req.body.idTeam exists. If not => error
  let team = null
  try {
    team = await Team.findOne({_id: req.body.idTeam}).exec()
  }
  catch(err) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_ADDHEROES_FAILED))
    return next(answer);
  }
  //  console.log("found team: "+team);
  // add all _id in req.body.heroes into the org team.
  heroes.forEach(h => {
    // search if h is not already affiliated to org
    let idx = team.members.findIndex(e => e._id.toString() === h._id.toString())
    if (idx !== -1) {
      console.log('cannot add '+h.name+'to '+team.name+' : already in !')
    }
    else {
      team.members.push(h._id)
    }
  })
  try {
    team = await team.save()
  }
  catch(err) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_ADDHEROES_FAILED))
    return next(answer);
  }

  answer.setPayload(team)
  res.status(200).send(answer);
};

/*
  req.body.idheroes is an array of _id
  req.body.idTeam is the _id of the affiliation team.
 */
const removeHeroes = async function (req, res, next) {
  answer.reset();
  console.log('remove heroes to a team');
  // check if all _id in req.body.heroes exist. If not => error
  let heroes = [];
  let hero = null
  for(let i=0;i<req.body.idHeroes.length;i++) {
    try {
      hero = await Hero.findOne({_id: req.body.idHeroes[i]}).exec()
      if (hero === null) {
        answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_REMHEROES_INVALID_DATA))
        return next(answer);
      }
      heroes.push(hero)
    } catch (err) {
      answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_REMHEROES_FAILED))
      return next(answer);
    }
  }
  // check if team with an _id = req.body.idTeam exists. If not => error
  let team = null
  try {
    team = await Team.findOne({_id: req.body.idTeam}).exec()
  }
  catch(err) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_REMHEROES_FAILED))
    return next(answer);
  }
  // add all _id in req.body.heroes into the org team.
  heroes.forEach(h => {
    // search if h is not already affiliated to org
    let idx = team.members.findIndex(e => e._id.toString() === h._id.toString())
    if (idx === -1) {
      console.log('cannot remove '+h.name+'to '+team.name+' : not member !')
    }
    else {
      team.members.splice(idx,1)
    }
  })
  try {
    team = await team.save()
  }
  catch(err) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_REMHEROES_FAILED))
    return next(answer);
  }
  // update each hero to be sure that the org. is present in the organizations field

  answer.setPayload(team)
  res.status(200).send(answer);
};


const getAll = async function (req, res, next) {
  answer.reset();
  console.log('get all teams and to how many organizations they are affiliated');
  // search if names already exists (nb: syntax using exec(), await and try/catch)
  let teams = null
  try {
    teams  = await Team.find({}, '_id name').exec()
  }
  catch(err) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_GETALL_FAILED))
    return next(answer);
  }
  let orgs = null
  try {
    orgs  = await Organization.find({}).exec()
  }
  catch(err) {
    answer.set(TeamErrors.getError(TeamErrors.ERR_TEAM_GETALL_FAILED))
    return next(answer);
  }
  let tab = []
  teams.forEach(t => {
    let count = 0;
    for (let j = 0; j < orgs.length; j++) {
      let idx = orgs[j].teams.findIndex(e => e._id.toString() === t._id.toString())
      if (idx !== -1) count++
    }
    tab.push({_id:t._id, name: t.name, nbAffiliations: count})
  })

  answer.setPayload(tab)
  res.status(200).send(answer);
};


module.exports = {
  create,
  update,
  addHeroes,
  removeHeroes,
  getAll,
}
