const Config = require("./config");
const ERR_USER_INVALID_FIND_LOGIN_REQUEST = 1127;
const ERR_USER_CANNOT_FIND_LOGIN = 1128;
const ERR_USER_INVALID_FIND_USER_REQUEST = 1133;
const ERR_USER_CANNOT_CREATE_USER = 1140;
const ERR_USER_CAPTCHATOKEN_FAILED = 1141;

const userErrors = [
  { number: ERR_USER_INVALID_FIND_LOGIN_REQUEST, status: 400, message:  { en: '', fr:  'requête de recherche d\'un utilisateur par login invalide' }},
  { number: ERR_USER_CANNOT_FIND_LOGIN, status: 404, message:  { en: '', fr:  'impossible de trouver un utilisateur avec le login indiqué' }},
  { number: ERR_USER_INVALID_FIND_USER_REQUEST, status: 400, message:  { en: '', fr:  'requête pour récupérer les utilisateurs invalide' }},
  { number: ERR_USER_CANNOT_CREATE_USER, status: 400, message:  { en: '', fr:  'impossible de créer un nouvel utilisateur' }},
  { number: ERR_USER_CAPTCHATOKEN_FAILED, status: 400, message:  { en: '', fr:  'la vérification du captcha a échoué' }},
];

const getError = (number, lang) => {
  if (lang === undefined) lang = Config.defaultLang;
  let err = userErrors.find(e => e.number === number);
  if (err !== undefined) {
    if (lang === 'en') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.en
      };
    }
    else if (lang === 'fr') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.fr
      };
    }
  }
  return {
    error: 1,
    status: 500,
    data: 'undetermined error'
  }
};

module.exports = {
  ERR_USER_INVALID_FIND_LOGIN_REQUEST,
  ERR_USER_CANNOT_FIND_LOGIN,
  ERR_USER_INVALID_FIND_USER_REQUEST,
  ERR_USER_CANNOT_CREATE_USER,
  ERR_USER_CAPTCHATOKEN_FAILED,
  getError
};


