const Config = require("./config");
const ERR_TEAM_CREATE_INVALID_DATA = 300; // if no/invalid data provided by the client
const ERR_TEAM_CREATE_ALREADY_EXISTS = 301; // if name already exists in DB
const ERR_TEAM_CREATE_FAILED = 302; // if insertion in DB fails

const ERR_TEAM_UPDATE_INVALID_DATA = 310; // if no/invalid data provided by the client
const ERR_TEAM_UPDATE_FAILED = 311; // if modification in DB fails

const ERR_TEAM_REMOVE_INVALID_DATA = 320; // if no/invalid data provided by the client (e.g. invalid _id)
const ERR_TEAM_REMOVE_FAILED = 321; // if deletion in DB fails

const ERR_TEAM_GET_INVALID_DATA = 330; // if no/invalid data provided by the client (e.g. the _id to find)
const ERR_TEAM_GET_FAILED = 331; // if no/invalid data provided by the client (e.g. the _id to find)

const ERR_TEAM_GETALL_FAILED = 340; // if no/invalid data provided by the client (e.g. the _id to find)

const ERR_TEAM_ADDHEROES_INVALID_DATA = 350; // if no/invalid data provided by the client (e.g. the _id to find)
const ERR_TEAM_ADDHEROES_FAILED = 351; // if no/invalid data provided by the client (e.g. the _id to find)

const ERR_TEAM_REMHEROES_INVALID_DATA = 360; // if no/invalid data provided by the client (e.g. the _id to find)
const ERR_TEAM_REMHEROES_FAILED = 361; // if no/invalid data provided by the client (e.g. the _id to find)

const teamsErrors = [
  { number: ERR_TEAM_CREATE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de créer une équipe : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_TEAM_CREATE_ALREADY_EXISTS, status: 400, message:  { en: '', fr:  'Impossible de créer une équipe : le nom fourni existe déjà'}},
  { number: ERR_TEAM_CREATE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de créer une équipe : la requête en base de données a echoué'}},
  { number: ERR_TEAM_UPDATE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de modifier une équipe : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_TEAM_UPDATE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de modifier une équipe : la requête en base de données a echoué'}},
  { number: ERR_TEAM_REMOVE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de supprimer une équipe : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_TEAM_REMOVE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de supprimer une équipe : la requête en base de données a echoué'}},
  { number: ERR_TEAM_GET_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de retrouver une équipe : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_TEAM_GET_FAILED, status: 400, message:  { en: '', fr:  'Impossible de retrouver une équipe : la requête en base de données a echoué'}},
  { number: ERR_TEAM_GETALL_FAILED, status: 400, message:  { en: '', fr:  'Impossible de retrouver toutes les équipes : la requête en base de données a echoué'}},
  { number: ERR_TEAM_ADDHEROES_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible d\'ajouter des héros à une équipe : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_TEAM_ADDHEROES_FAILED, status: 400, message:  { en: '', fr:  'Impossible d\'ajouter des héros à une équipe : la requête en base de données a echoué'}},
  { number: ERR_TEAM_REMHEROES_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de supprimer des héros à une équipe : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_TEAM_REMHEROES_FAILED, status: 400, message:  { en: '', fr:  'Impossible de supprimer des héros à une équipe : la requête en base de données a echoué'}},
];

const getError = (number, lang) => {
  if (lang === undefined) lang = Config.defaultLang;
  let err = teamsErrors.find(e => e.number === number);
  if (err !== undefined) {
    if (lang === 'en') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.en
      };
    }
    else if (lang === 'fr') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.fr
      };
    }
  }
  return {
    error: 1,
    status: 500,
    data: 'undetermined error'
  }
};

module.exports = {
  ERR_TEAM_CREATE_INVALID_DATA,
  ERR_TEAM_CREATE_ALREADY_EXISTS,
  ERR_TEAM_CREATE_FAILED,
  ERR_TEAM_UPDATE_INVALID_DATA,
  ERR_TEAM_UPDATE_FAILED,
  ERR_TEAM_REMOVE_INVALID_DATA,
  ERR_TEAM_REMOVE_FAILED,
  ERR_TEAM_GET_INVALID_DATA,
  ERR_TEAM_GET_FAILED,
  ERR_TEAM_GETALL_FAILED,
  ERR_TEAM_ADDHEROES_INVALID_DATA,
  ERR_TEAM_ADDHEROES_FAILED,
  ERR_TEAM_REMHEROES_INVALID_DATA,
  ERR_TEAM_REMHEROES_FAILED,
  getError
};


