const Config = require("./config");
const ERR_ORGANIZATION_CREATE_INVALID_DATA = 200; // if no/invalid data provided by the client
const ERR_ORGANIZATION_CREATE_ALREADY_EXISTS = 201; // if name already exists in DB
const ERR_ORGANIZATION_CREATE_FAILED = 202; // if insertion in DB fails

const ERR_ORGANIZATION_UPDATE_INVALID_DATA = 210; // if no/invalid data provided by the client
const ERR_ORGANIZATION_UPDATE_FAILED = 211; // if modification in DB fails

const ERR_ORGANIZATION_REMOVE_INVALID_DATA = 220; // if no/invalid data provided by the client (e.g. invalid _id)
const ERR_ORGANIZATION_REMOVE_FAILED = 221; // if deletion in DB fails

const ERR_ORGANIZATION_GET_INVALID_DATA = 230; // if no/invalid data provided by the client (e.g. the _id to find)
const ERR_ORGANIZATION_GET_FAILED = 231; // if no/invalid data provided by the client (e.g. the _id to find)

const ERR_ORGANIZATION_GETALL_FAILED = 240; // if no/invalid data provided by the client (e.g. the _id to find)

const ERR_ORGANIZATION_ADDTEAM_INVALID_DATA = 250; // if no/invalid data provided by the client (e.g. the _id to find)
const ERR_ORGANIZATION_ADDTEAM_FAILED = 251; // if no/invalid data provided by the client (e.g. the _id to find)

const ERR_ORGANIZATION_REMTEAM_INVALID_DATA = 260; // if no/invalid data provided by the client (e.g. the _id to find)
const ERR_ORGANIZATION_REMTEAM_FAILED = 261; // if no/invalid data provided by the client (e.g. the _id to find)

const ERR_ORGANIZATION_INVALID_SECRET = 299; // if no/invalid data provided by the client (e.g. the _id to find)

const orgsErrors = [
  { number: ERR_ORGANIZATION_CREATE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de créer une organisation : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_ORGANIZATION_CREATE_ALREADY_EXISTS, status: 400, message:  { en: '', fr:  'Impossible de créer une organisation : le nom et/ou le secret fourni existe déjà'}},
  { number: ERR_ORGANIZATION_CREATE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de créer une organisation : la requête en base de données a echoué'}},
  { number: ERR_ORGANIZATION_UPDATE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de modifier une organisation : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_ORGANIZATION_UPDATE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de modifier une organisation : la requête en base de données a echoué'}},
  { number: ERR_ORGANIZATION_REMOVE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de supprimer une organisation : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_ORGANIZATION_REMOVE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de supprimer une organisation : la requête en base de données a echoué'}},
  { number: ERR_ORGANIZATION_GET_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de retrouver une organisation : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_ORGANIZATION_GET_FAILED, status: 400, message:  { en: '', fr:  'Impossible de retrouver une organisation : la requête en base de données a echoué'}},
  { number: ERR_ORGANIZATION_GETALL_FAILED, status: 400, message:  { en: '', fr:  'Impossible de retrouver toutes les organisations : la requête en base de données a echoué'}},
  { number: ERR_ORGANIZATION_ADDTEAM_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible d\'ajouter une équipe à une organisation : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_ORGANIZATION_ADDTEAM_FAILED, status: 400, message:  { en: '', fr:  'Impossible d\'ajouter une équipe à une organisation : la requête en base de données a echoué'}},
  { number: ERR_ORGANIZATION_REMTEAM_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de supprimer une équipe à une organisation : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_ORGANIZATION_REMTEAM_FAILED, status: 400, message:  { en: '', fr:  'Impossible de supprimer une équipe à une organisation : la requête en base de données a echoué'}},
  { number: ERR_ORGANIZATION_INVALID_SECRET, status: 400, message:  { en: '', fr:  'Impossible d\'accéder à une organisation : clé secrète invalide ou inexsitante'}},
];

const getError = (number, lang) => {
  if (lang === undefined) lang = Config.defaultLang;
  let err = orgsErrors.find(e => e.number === number);
  if (err !== undefined) {
    if (lang === 'en') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.en
      };
    }
    else if (lang === 'fr') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.fr
      };
    }
  }
  return {
    error: 1,
    status: 500,
    data: 'undetermined error'
  }
};

module.exports = {
  ERR_ORGANIZATION_CREATE_INVALID_DATA,
  ERR_ORGANIZATION_CREATE_ALREADY_EXISTS,
  ERR_ORGANIZATION_CREATE_FAILED,
  ERR_ORGANIZATION_UPDATE_INVALID_DATA,
  ERR_ORGANIZATION_UPDATE_FAILED,
  ERR_ORGANIZATION_REMOVE_INVALID_DATA,
  ERR_ORGANIZATION_REMOVE_FAILED,
  ERR_ORGANIZATION_GET_INVALID_DATA,
  ERR_ORGANIZATION_GET_FAILED,
  ERR_ORGANIZATION_GETALL_FAILED,
  ERR_ORGANIZATION_ADDTEAM_INVALID_DATA,
  ERR_ORGANIZATION_ADDTEAM_FAILED,
  ERR_ORGANIZATION_REMTEAM_INVALID_DATA,
  ERR_ORGANIZATION_REMTEAM_FAILED,
  ERR_ORGANIZATION_INVALID_SECRET,
  getError
};


