const Config = require("./config");
const ERR_HERO_CREATE_INVALID_DATA = 100; // if no/invalid data provided by the client
const ERR_HERO_CREATE_ALREADY_EXISTS = 101; // if hero publicName/realName already exists in DB
const ERR_HERO_CREATE_FAILED = 102; // if insertion in DB fails

const ERR_HERO_UPDATE_INVALID_DATA = 110; // if no/invalid data provided by the client
const ERR_HERO_UPDATE_FAILED = 111; // if modification in DB fails

const ERR_HERO_REMOVE_INVALID_DATA = 120; // if no/invalid data provided by the client (e.g. invalid _id) 
const ERR_HERO_REMOVE_FAILED = 121; // if deletion in DB fails

const ERR_HERO_GET_INVALID_DATA = 130; // if no/invalid data provided by the client (e.g. the _id to find)
const ERR_HERO_GET_FAILED = 131; // if request in DB fails

const ERR_HERO_GETALL_FAILED = 140; // if request in DB fails

const heroErrors = [
  { number: ERR_HERO_CREATE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de créer un héro : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_HERO_CREATE_ALREADY_EXISTS, status: 400, message:  { en: '', fr:  'Impossible de créer un héro : les noms fournis existent déjà'}},
  { number: ERR_HERO_CREATE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de créer un héro : la requête en base de données a echoué'}},
  { number: ERR_HERO_UPDATE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de modifier un héro : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_HERO_UPDATE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de modifier un héro : la requête en base de données a echoué'}},
  { number: ERR_HERO_REMOVE_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de supprimer un héro : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_HERO_REMOVE_FAILED, status: 400, message:  { en: '', fr:  'Impossible de supprimer un héro : la requête en base de données a echoué'}},
  { number: ERR_HERO_GET_INVALID_DATA, status: 400, message:  { en: '', fr:  'Impossible de retrouver un héro : les données fournies sont inexistantes ou invalides'}},
  { number: ERR_HERO_GET_FAILED, status: 400, message:  { en: '', fr:  'Impossible de retrouver un héro : la requête en base de données a echoué'}},
  { number: ERR_HERO_GETALL_FAILED, status: 400, message:  { en: '', fr:  'Impossible de retrouver tous les héros : la requête en base de données a echoué'}},
];

const getError = (number, lang) => {
  if (lang === undefined) lang = Config.defaultLang;
  let err = heroErrors.find(e => e.number === number);
  if (err !== undefined) {
    if (lang === 'en') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.en
      };
    }
    else if (lang === 'fr') {
      return {
        error: err.number,
        status: err.status,
        data: err.message.fr
      };
    }
  }
  return {
    error: 1,
    status: 500,
    data: 'undetermined error'
  }
};

module.exports = {
  ERR_HERO_CREATE_INVALID_DATA,
  ERR_HERO_CREATE_ALREADY_EXISTS,
  ERR_HERO_CREATE_FAILED,
  ERR_HERO_UPDATE_INVALID_DATA,
  ERR_HERO_UPDATE_FAILED,
  ERR_HERO_REMOVE_INVALID_DATA,
  ERR_HERO_REMOVE_FAILED,
  ERR_HERO_GET_INVALID_DATA,
  ERR_HERO_GET_FAILED,
  ERR_HERO_GETALL_FAILED,
  getError
};


