let fs = require('fs');
let https = require('https');
let privateKey  = fs.readFileSync('ssl/rpgapi.key', 'utf8');
let certificate = fs.readFileSync('ssl/rpgapi.crt', 'utf8');
let credentials = {key: privateKey, cert: certificate};
const cookieParser = require('cookie-parser');
const Config = require("./commons/config");

// setup express
const express = require('express')
const bodyParser = require('body-parser')
const cors = require("cors")

// import routes
const heroRouter = require('./routes/herocorp.route')
const authRouter = require('./routes/authapi.route')

// setup express
const app = express();

// setup cors options so that any origin is valid
let corsOptions = {
  methods: 'GET,POST,PUT,PATCH,DELETE',
  origin: [ /.*$/ ],
  allowedHeaders: "x-xsrf-token, app-key, org-secret, Origin, Content-Type, Accept",
  credentials: true,
}

// setup mongo connection
const mongoose = require('mongoose')
let dev_db_url = 'mongodb://localhost/apidemo'
let mongoDB = process.env.MONGODB_URI || dev_db_url
//mongoose.set('debug',true);
mongoose.connect(mongoDB)
mongoose.Promise = global.Promise
let db = mongoose.connection
db.on('error', console.error.bind(console, 'MongoDB connection error:'))

//mongoose.set('useFindAndModify', false);
// get the Right model to initialize Rights collection if it is empty

// If needed, init the Db to set 2 users : toto and test with pass = azer
const DbInit = require('./datasource/db.init')
DbInit.initBdD()

// define pre-processing: CORS, parsing JSON, ...
app.use(cookieParser(Config.secretKey))
app.use(cors(corsOptions))
app.use(bodyParser.json())
app.use(bodyParser.urlencoded({extended: false}))

// define routes
app.use('/herocorp', heroRouter)
app.use('/authapi',authRouter)

// if an invalid route is used, return error 404
app.use((req,res,next) => {
  res.status(404).send({error:1, status: 404, data: 'route d\'accès à l\'API invalide'})
})

// define error control
app.use((err, req, res, next) => {
  console.log(JSON.stringify(err));
  if (err.status === undefined) {
    res.status(500).send({error:2, status: 500, data: 'Erreur interne de \'API'})
  }
  else {
    res.status(err.status).send(err)
  }
});

// default is prod
let env = Config.environments.production

if ((process.env.NODE_ENV) && (process.env.NODE_ENV === 'dev')) {
  env = Config.environments.dev
}

// start server
let httpsServer = https.createServer(credentials, app);
httpsServer.listen(env.httpPORT, () =>
  console.log(`apidemo started on port ${env.httpPORT}, in ${env.envName} mode!`)
);

