/**
 * defines methods to interact with Hero documents
 * @module HeroController
 */
const HeroErrors = require('../../commons/hero.errors')
const Organization = require('../../models/herocorp/organization.model')
const OrganizationErrors = require('../../commons/organization.errors')

const {answer} =  require('../ControllerAnswer')


function getSecret(req) {
  let secretHeader = req.headers['org-secret']
  let secretQuery = req.query['org-secret']
  console.log('secret from header: '+secretHeader)
  console.log('secret from query: '+secretQuery)
  let secret = undefined
  if (secretHeader) {
    secret = secretHeader
  }
  else if (secretQuery) {
    secret = secretQuery
  }
  return secret
}

/**
 * this function does not return anything but relies on Anwser to store the result
 * @param req
 * @returns {Promise<void>}
 */
const checkOrgSecret = async function (req) {
  answer.reset()
  // search if names already exists (nb: syntax using exec(), await and try/catch)
  let secret = getSecret(req)
  if (!secret) {
    answer.set(OrganizationErrors.getError(OrganizationErrors.ERR_ORGANIZATION_INVALID_SECRET))
    return
  }
  // check if secret matches an org.
  let orgs = null
  try {
    orgs = await Organization.find({secret: secret}).populate('teams').exec()
  } catch (err) {
    answer.set(OrganizationErrors.getError(OrganizationErrors.ERR_ORGANIZATION_INVALID_SECRET))
    return
  }
  if (orgs.length !== 1) {
    //console.log('no orgs or too many')
    answer.set(OrganizationErrors.getError(OrganizationErrors.ERR_ORGANIZATION_INVALID_SECRET))
    return
  }
  answer.setPayload(orgs[0])
}

/**
 * this function does not return anything but relies on Anwser to store the result
 * @param req
 * @param idHero
 * @returns {Promise<*>}
 */
const checkAccessToHero = async function (req, idHero) {
  answer.reset()
  await checkOrgSecret(req)
  if (answer.isError()) {
    //console.log('no secret cannot access to hero')
    return
  }

  let org = answer.getPayload()
  let inTeam = false
  for(let i=0;i<org.teams.length;i++) {
    let t = org.teams[i]
    let idx = t.members.findIndex(m => m.toString() === idHero)
    if (idx !== -1) {
      inTeam = true; break;
    }
  }
  if (!inTeam) {
    console.log('hero not in a team within provided org')
    answer.set(HeroErrors.getError(HeroErrors.ERR_HERO_GET_FAILED))
    return
  }
  // else resest anwser to no error
  answer.reset()
}


module.exports = {
  checkOrgSecret,
  checkAccessToHero,
}

