import { ref, computed } from 'vue'
import { defineStore } from 'pinia'

export const useErrorStore = defineStore('errors', () => {
  /* ***********************
    STATE
  *********************** */
  const isError = ref(false)
  const errorMsg = ref('')

  /* ***********************
    ACTIONS
  *********************** */
  function pushError(msg){
    errorMsg.value = msg
    isError.value = true
  }
  function popError() {
    isError.value = false
  }

  return {
    errorMsg,isError,
    pushError,popError,
  }
})
