import { ref, computed } from 'vue'
import { defineStore } from 'pinia'
import {useErrorStore} from "@/stores/errors.js";

export const useAuthStore = defineStore('auth', () => {
  /* ***********************
    STATE
  *********************** */
  const auth = ref(false)

  /* ***********************
    ACTIONS
  *********************** */
  async function login(credentials) {
    /*
     Normally, this check should be done remotely.
     Simulate the answer delay with setTimeout()
      */
    await new Promise(resolve => {
      setTimeout(resolve, 1000)
    })

    if ((credentials.login === 'toto') && (credentials.passwd === 'azer')) {
      auth.value = true
    } else {
      const errorStore = useErrorStore()
      auth.value = false
      errorStore.pushError('Invalid credentials')
    }
  }

    function logout() {
      auth.value = false

  }

  return {
    auth, login, logout,
  }
})
