import { createRouter, createWebHistory } from 'vue-router'
import {useErrorStore} from "@/stores/errors.js";
import {useAuthStore} from "@/stores/auth.js";

const routes = [
  {
    path: '/',
    components: {
      root: () => import('@/views/TD2HomeView.vue')
    },
  },
  {
    path: '/demo1',
    name: 'Demo1',
    components: {
      root: () => import('@/views/TD2Demo1View.vue')
    },
  },
  {
    path: '/demo2',
    name: 'Demo2',
    components: {
      root: () => import('@/views/TD2Demo2View.vue')
    },
    children: [
      {
        path: 'checkfirstname',
        name: 'checkfirstname',
        components: {
          central: () => import ('@/views/TD2Demo2AView.vue')
        }
      },
      {
        path: 'checklastname',
        name: 'checklastname',
        components: {
          central: () => import ('@/views/TD2Demo2BView.vue')
        }
      }
    ],
  },
  {
    path:'/login',
    components: {
      root: () => import('@/components/LoginForm.vue')
    },
    meta: { levelAuth: 0 },
  },
  {
    path: '/demo3',
    name: 'Demo3',
    components: {
      root: () => import('@/views/TD2Demo3View.vue')
    },
    children: [
      {
        path:'freeroute',
        components: {
          central: () => import('@/views/FreeView.vue')
        },
        meta: { levelAuth: 0 },
      },
      {
        path:'privateroute',
        components: {
          central: () => import('@/views/PrivateView.vue')
        },
        meta: { levelAuth: 1 },
      },
    ]
  },
  // fallback route when no other matches => error
  {
    path:'/:pathMatch(.*)',
    name:'error404',
  },
]

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: routes,
})

function checkAccess(to) {
  const authStore = useAuthStore()
  // BEWARE: routes without a meta levelAuth field are considered to be public
  if ((to.meta.levelAuth) && (to.meta.levelAuth === 1) && (authStore.auth === false)) {
    return false
  }
  return true
}

// check for all routes needing privileges that user is authenticated
router.beforeEach((to, from, next) => {
  const errorStore = useErrorStore()
  if (to.name === 'error404') {
    errorStore.pushError('Invalid route')
    next('/')
  }
  else if (checkAccess(to)) {
    next()
  }
  else {
    errorStore.pushError('You need to login')
    next('/login');
  }
});

export default router
