import { ref } from 'vue'
import { defineStore } from 'pinia'
import {getAllItemsService, updateItemPriceService} from "@/services/items.service.js";
import {getAllTownsService} from "@/services/towns.service.js";

export const useTownStore = defineStore('towns', () => {
  /* ***********************
    STATE
  *********************** */
  const towns = ref([])
  const items = ref([])

  /* ***********************
    ACTIONS
  *********************** */
  async function getAllItems(){
    let res = await getAllItemsService()
    if (res.error === 0) {
      items.value = res.data
    }
    else {
      let msg = "cannot get all items from API"+ res.data
      alert(msg)
    }
  }

  async function getAllTowns(){
    let res = await getAllTownsService()
    if (res.error === 0) {
      towns.value = res.data
    }
    else {
      let msg = "cannot get all towns from API"+ res.data
      alert(msg)
    }
  }

  /* Fonction pour mettre à jour le prix

  async function updateItemPrice(id, price) {
    let res = await updateItemPriceService(id, price)
    if (res.error === 0) {
      // met à jour le prix de l'item dans le store
      let item = items.value.find(it => it._id === id)
      item.price = price
    }
    else {
      alert("cannot change price")
    }
  }
   */

  return {
    towns, items,
    getAllItems, getAllTowns,
    // updateItemPrice
  }
})
