import {getRequest, patchRequest} from "@/services/axios.service";

async function getAllItemsFromAPI() {
  return getRequest('/items/get', 'GETALLITEMS')
}

async function getItemByIdFromAPI(id) {
  return getRequest('/items/getbyid/'+id, 'GETITEMBYID')
}

async function getItemByNameFromAPI(name) {
  return getRequest('/items/getbyname/'+name, 'GETITEMBYNAME')
}

async function updateItemPriceFromAPI(id, price) {
  let data = {
    id: id,
    price: price,
  }
  return patchRequest('/items/updateprice', data, 'UPDATEITEMPRICE')
}

async function getAllItemsService() {
  // response est ce qui est renvoyé par axiosAgent donc la réponse brute de l'API
  let response = await getAllItemsFromAPI()
  return response
}

async function getItemByIdService(id) {
  let response = await getItemByIdFromAPI(id)
  return response
}

async function getItemByNameService(name) {
  let response = await getItemByNameFromAPI(name)
  return response
}

async function updateItemPriceService(id, price) {
  let response = await updateItemPriceFromAPI(id, price)
  return response
}

export {
  getAllItemsService,
  getItemByIdService,
  getItemByNameService,
  updateItemPriceService,
}