import { ref, computed } from 'vue'
import { defineStore } from 'pinia'

export const useCanvasStore = defineStore('counter', () => {
  /* ***********************
    STATE
  *********************** */
  const width = ref(300)

  /* ***********************
    ACTIONS
  *********************** */
  function increment(amount) {
    width.value += amount
  }

  function decrement(amount) {
    width.value -= amount
  }
  return {
    width,
    increment, decrement,
  }
})
