const fs = require("fs");
const path = require("path");
const filePath = path.join(__dirname,"..", "products.json");

const createProduct = (name, description, price, callback) =>{
    let products = [];
    try { // LECTURE
        const data = fs.readFileSync(filePath,'utf-8');
        const dataStr = data.toString();
        products = JSON.parse(dataStr);
    }catch (error) {console.log(error)}
    const newProduct = {name,description,price};
    products.push(newProduct);
    // ECRITURE
    try {
        fs.writeFileSync(filePath,JSON.stringify(products));
        callback(null,"success"); // ERROR FIRST (ERROR - DATA)
    }catch(errorWrite){
        console.log(errorWrite);
        callback(errorWrite, null);
    }
}

const updateProduct = (productName, name, description, price, callback) => {
    let products = [];
    try {
        const data = fs.readFileSync(filePath, 'utf-8');
        const dataStr = data.toString();
        products = JSON.parse(dataStr);
    } catch (error) {
        console.log(error);
        return callback(error, null);
    }

    const index = products.findIndex(p => p.name === productName);
    if (index === -1) {
        return callback(new Error("Product not found"), null);
    }

    products[index] = { name, description, price };

    try {
        fs.writeFileSync(filePath, JSON.stringify(products));
        callback(null, "success");
    } catch (errorWrite) {
        console.log(errorWrite);
        callback(errorWrite, null);
    }
}

const deleteProduct = (productName, callback) => {
    let products = [];
    try {
        const data = fs.readFileSync(filePath, 'utf-8');
        const dataStr = data.toString();
        products = JSON.parse(dataStr);
    } catch (error) {
        console.log(error);
        return callback(error, null);
    }

    const index = products.findIndex(p => p.name === productName);
    if (index === -1) {
        return callback(new Error("Product not found"), null);
    }

    products.splice(index, 1);

    try {
        fs.writeFileSync(filePath, JSON.stringify(products));
        callback(null, "success");
    } catch (errorWrite) {
        console.log(errorWrite);
        callback(errorWrite, null);
    }
}

const getProducts = (callback) => {
    try {
        const data = fs.readFileSync(filePath, 'utf-8');
        const dataStr = data.toString();
        const products = JSON.parse(dataStr);
        callback(null, products);
    } catch (error) {
        console.log(error);
        callback(error, null);
    }
}

module.exports = {
    createProduct,
    updateProduct,
    deleteProduct,
    getProducts
}