const express = require("express");
const productsController = 
                require("../controllers/products.controller");
const productsMiddleware = 
                require("../middlewares/products.middleware");
var router = express.Router();

router.get("/objects", productsController.getObjects);
// /api/products/filter?name=xxx&minPrice=10&maxPrice=50
router.get("/filter", productsController.getFilteredProducts);
// /api/products/
router.post("/",productsMiddleware.validateProduct,
    productsController.saveProduct);
// /api/products/:id()
router.put("/:id", productsMiddleware.validateProduct,
    productsController.updateProduct);
// /api/products/:id
router.delete("/:id", productsController.deleteProduct);

module.exports = router; 