const validator = require("validator");
exports.validateProduct = (req,res,next) => {
    const {name,description,price} = req.body;
    if(!name || !description || !price){
        return res.status(400).json({
            message:'All fields are required.'
        });
    }
    if(!validator.isLength(name,{min:2, max:50})){
        return res.status(400).json({
            message:'Name between 2 and 50 characters.'
        });
    }
    if(!validator.isLength(description,{min:5, max:200})){
        return res.status(400).json({
            message:'Description between 5 and 200 characters.'
        });
    }
    if(!validator.isFloat(price.toString(),{min:0,max:1000})){
        return res.status(400).json({
            message:'Price numeric between 0 and 1000'
        });
    }
    next();
}