const express = require("express");
const axios = require("axios");
const app = express();
const path = require("path");
const productsRoutes=require("./routes/products.router");
const port = 3000; 


// Configuration EJS
app.set('view engine','ejs');
app.set('views',path.join(__dirname,'views'));

// Middlewares
app.use(express.json());
app.use(express.urlencoded({extended:true}));
app.use(express.static(path.join(__dirname,'public')));

app.get("/", async (req,res,next)=>{
    try{
        const response = 
            await axios.get('https://api.restful-api.dev/objects');
        const products = response.data;
        res.render('products', {
          products: products 
        });
    }catch(err){
        console.log(err);
        const error = new Error(err.message);
        error.status(500);
        next(error);
        //res.status(500).send("Internal Error");
    }
})


app.use("/api/products", productsRoutes);

// Middleware 404 ==> Any route
app.use((req,res,next)=>{
    const error = new Error("Route non trouvée");
    error.status = 404; 
    next(error);
});

// Error handling
app.use((err,req,res,next)=>{
    console.error(err.stack);
    // 404 et 50X (internes)
    if(err.status === 404){
        res.sendFile(path.join(__dirname,'public/404.html'))
    }else{
        res.sendFile(path.join(__dirname,'public/50x.html'))
    }
});



app.listen(port, ()=> {
    console.log(`Serveur ecoute sur port ${port}`);
})