const productsService = require("../services/products.service");
exports.getObjects = async (req,res,next) =>{
        try{
            productsService.getProducts((error, products) => {
                if (error) {
                    console.log(error);
                    const cbError = new Error(error.message);
                    cbError.status = 500;
                    next(cbError);
                } else {
                    res.status(200).json(products);
                }
            });
        }catch(err){
            console.log(err);
            const error = new Error(err.message);
            error.status = 500;
            next(error);
        }
}
exports.saveProduct = async (req,res,next) => {
    try{
        const {name,description,price} = req.body;
        console.log(`${name} - ${description} - ${price}`);
        productsService.createProduct(name,description,price,
            (error, data)=>{
                if(error) {
                    console.log(error);
                    const cbError = new Error(error.message);
                    cbError.status(500);
                    next(cbError);
                }else{
                    res.status(201).send("Product created successfully!");
                }
            }
        )
    }catch(err){
            console.log(err);
            const error = new Error(err.message);
            error.status(500);
            next(error);
        }
}

exports.updateProduct = async (req, res, next) => {
    try {
        const { id } = req.params;
        const { name, description, price } = req.body;
        console.log(`Updating product ${id}: ${name} - ${description} - ${price}`);
        productsService.updateProduct(id, name, description, price,
            (error, data) => {
                if (error) {
                    console.log(error);
                    const cbError = new Error(error.message);
                    cbError.status = error.message === "Product not found" ? 404 : 500;
                    next(cbError);
                } else {
                    res.status(200).send("Product updated successfully!");
                }
            }
        )
    } catch (err) {
        console.log(err);
        const error = new Error(err.message);
        error.status = 500;
        next(error);
    }
}

exports.deleteProduct = async (req, res, next) => {
    try {
        const { id } = req.params;
        console.log(`Deleting product ${id}`);
        productsService.deleteProduct(id,
            (error, data) => {
                if (error) {
                    console.log(error);
                    const cbError = new Error(error.message);
                    cbError.status = error.message === "Product not found" ? 404 : 500;
                    next(cbError);
                } else {
                    res.status(200).send("Product deleted successfully!");
                }
            }
        )
    } catch (err) {
        console.log(err);
        const error = new Error(err.message);
        error.status = 500;
        next(error);
    }
}

exports.getFilteredProducts = async (req, res, next) => {
    try {
        const { name, minPrice, maxPrice } = req.query;
        productsService.getProducts((error, products) => {
            if (error) {
                console.log(error);
                const cbError = new Error(error.message);
                cbError.status = 500;
                next(cbError);
            } else {
                let filtered = products;

                if (name) {
                    filtered = filtered.filter(p =>
                        p.name.toLowerCase().includes(name.toLowerCase())
                    );
                }

                if (minPrice) {
                    filtered = filtered.filter(p => p.price >= parseFloat(minPrice));
                }

                if (maxPrice) {
                    filtered = filtered.filter(p => p.price <= parseFloat(maxPrice));
                }

                res.status(200).json(filtered);
            }
        });
    } catch (err) {
        console.log(err);
        const error = new Error(err.message);
        error.status = 500;
        next(error);
    }
}
