const fs  = require("fs");
const path = require("path");
const filePath = 
    path.join(__dirname,"..","products.json");

const createProduct = (name,description,price,callback)=> {
    let products = [];
    try{ // LECTURE 
        const data = fs.readFileSync(filePath,'utf-8');
        const dataStr = data.toString();
        products = JSON.parse(dataStr);
    }catch(error) {
        console.log(error);
    }
    const newProduct = {name,description,price};
    products.push(newProduct);
    try{ // ECRITURE
        fs.writeFileSync(filePath, JSON.stringify(products));
        callback(null, newProduct);
    }catch(writeError) {
        console.log(writeError);
        callback(writeError,null)   // ERROR FIRST (error, data)
    }
}
const getProducts = (callback) => {
    try{
        const data = fs.readFileSync(filePath,'utf-8');
        const dataStr = JSON.stringify(data);
        callback(null,JSON.parse(dataStr));
    }catch(error){
        console.log(error);
        callback(error,null);
    }
}
const updateProduct = (name,description,price,callback)=>{
    let products = [];
    try{ // LECTURE 
        const data = fs.readFileSync(filePath,'utf-8');
        const dataStr = data.toString();
        products = JSON.parse(dataStr);
    }catch(error) {
        console.log(error);
    }
    const productIndex = products.findIndex(p => p.name==name);
    if(productIndex<0){
        return callback("Product not found!",null) 
        // error first (error,data)
    }
    products[productIndex] = {name:name,
        description:description,price:price};
    try{ // ECRITURE
        fs.writeFileSync(filePath, JSON.stringify(products));
        callback(null, products);
    }catch(writeError) {
        console.log(writeError);
        callback(writeError,null)   // ERROR FIRST (error, data)
    }    
}

const deleteProduct = (name,callback) =>{
    let products = [];
    try{ // LECTURE 
        const data = fs.readFileSync(filePath,'utf-8');
        const dataStr = data.toString();
        products = JSON.parse(dataStr);
    }catch(error) {
        console.log(error);
    }
    let productsSize = products.length;
    products = products.filter(product => product.name != name);
    if(products.length === productsSize){
        return callback("Product not found!", null);
    }
    try{ // ECRITURE
        fs.writeFileSync(filePath, JSON.stringify(products));
        callback(null, "Suppression avec succes");
    }catch(writeError) {
        console.log(writeError);
        callback(writeError,null)   // ERROR FIRST (error, data)
    }       
}
module.exports = {
    createProduct,getProducts,updateProduct,deleteProduct
}
