const express = require("express");
const productsController = 
            require("../controllers/products.controller");
const productsMiddleware = 
            require("../middlewares/products.middleware");
var router = express.Router();
// /api/products/ POST
router.post("/",  
    productsMiddleware.validateProduct
    ,productsController.saveProduct);
// /api/products/
router.get("/", productsController.getProducts);
// /api/products/filter?name=xxx&minPrice=2&maxPrice=10
router.get("/filter", 
        productsController.getFilteredProducts);
        
router.put("/:name", productsMiddleware.validateProductUpdate,
    productsController.updateProduct
)
router.delete("/:name", productsController.deleteProduct);
module.exports = router; 