const express = require("express");
const axios = require("axios");
const path = require("path");
const app = express();
const productsRoutes = 
            require("./routes/products.router");
const port = 3000; 
//CONFIGURATION EJS
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname,'views'));


//MIDDLEWARES
app.use(express.json()); 
app.use(express.urlencoded({extended:true}));
app.use(express.static(path.join(__dirname,'public')));

//ROUTEURS
app.get("/",async (req,res)=>{
    try{
        const response =
             await axios.get("https://api.restful-api.dev/objects");
        const products = response.data;
        res.render('products', {
            products: products,
            title: 'Liste des Produits'
        });
    }catch(err){
        res.status(500).send("Erreur interne");
    }
});

app.use("/api/products",productsRoutes);

// Middleware 404
app.use((req,res,next)=> {
    const error = new Error("Route non trouvée");
    error.status = 404;
    next(error);
});
// Gestion des erreurs
app.use((err,req,res,next)=>{
    console.error(err.stack);
    if(err.status === 404){
        res.sendFile(__dirname + "/public/404.html");
    }else{
        res.sendFile(__dirname + "/public/50x.html");
    }
});


app.listen(port, ()=> {
    console.log(`Serveur écoute sur port ${port}`);
})