const productsService = require("../services/products.services");
exports.saveProduct = async (req,res,next) => {
    try{
        const {name,description,price} = req.body;
        console.log(`${name}-${description}-${price}`)
        productsService.createProduct(name,description,price,
            (err, data) => {
                if(err){
                    res.status(500).send("Erreur interne.");
                }else{
                    res.status(201).json({
                        status: "success",
                        new_product: data
                    })
                }
            }
        );
    }catch(error){
        console.log(error);
        const ctError = new Error(error.message);
        ctError.status(500);
        next(ctError);
    }
}

exports.getProducts = async (req,res,next)=>{
    try{
        productsService.getProducts((err,data)=>{
            if(err) {res.status(500).send("Erreur interne")}
            else {res.status(200).send(data)}
        })
   }catch(error){
        console.log(error);
        const ctError = new Error(error.message);
        ctError.status(500);
        next(ctError);
    }
}
exports.getFilteredProducts = async (req,res,next)=>{
    try{
        const {name, minPrice,maxPrice} = req.query;
        productsService.getProducts((err,data)=>{
            if(err){
                res.status(500).send("Erreur interne");
            }else{
                let filtered = JSON.parse(data); 
                console.log(typeof filtered);
                if(name){
                    filtered = filtered.filter(p=>
                        p.name.toLowerCase().includes(name.toLowercase())
                    ); 
                }
                if(minPrice){
                    filtered = filtered.filter(p=>p.price >= parseFloat(minPrice))
                }
                if(maxPrice){
                    filtered = filtered.filter(p=>p.price <= parseFloat(maxPrice))
                }
                res.status(200).send(filtered);
            }
        })
    }catch(error){
        console.log(error);
        const ctError = new Error(error.message);
        ctError.status(500);
        next(ctError);
    }

} 

exports.updateProduct = async (req, res, next)=> {
    try{
        const {description,price} = req.body;
        const name = req.params.name;
        // service
        productsService.updateProduct(name,description,price,
            (err,data)=>{
                if(err){
                    console.log(err);
                    return res.status(500).send("Internal error");
                }
                return res.status(201).json({
                    message: "Mise a jour avec succes",
                    data: data
                });
            });
    }catch(error){
        console.log(error);
        const ctError = new Error(error.message);
        ctError.status(500);
        next(ctError);
    }
}
exports.deleteProduct = async (req, res, next)=> {
    const name = req.params.name;
    if(!name){return res.status(400).send("name required!")}
    productsService.deleteProduct(name,(err,data)=>{
        if(err){
            console.log(err);
            return res.status(500).send('Internal Error');
        }
        return res.status(200).send(data);
    });
}