const requireLogin = require("../middlewares/requireLogin");
const mongoose = require("mongoose");
const User = mongoose.model("User");
const Blog = mongoose.model("Blog");
const Comment = mongoose.model("Comment"); 
const {cacheMiddleware,getClient,isConnected,invalidateCache} = 
                                require("../middlewares/cache");
module.exports = app => {
    app.get('/api/blogs/:id',
        requireLogin,cacheMiddleware('blog',120), async (req,res)=>{
        const blog = await Blog.findOne({
            _id: req.params.id
        });
        res.send(blog);
    });
    app.get('/api/blogs',requireLogin,cacheMiddleware('blog',120),
        async (req,res)=> {
            const blogs=await Blog.find({});
            res.send(blogs);
        }
    );
    app.post('/api/blogs',requireLogin,
        async (req,res)=>{
            const {title,content,user} = req.body;
            const blog = new Blog({
                title:title,content:content,
                _user : user
            });
            try{
                await blog.save(); 
                if(isConnected()){
                    const redisClient = getClient();
                    console.log("WRITE THROUGH");
                    const blogCacheKey=`blog:/api/blogs/${blog._id}`;
                    await redisClient.set(blogCacheKey,
                        JSON.stringify(blog),
                        {EX:120}
                    );
                    const listCacheKey=`blog:/api/blogs/`;
                    await invalidateCache(listCacheKey);
                }
                res.send(blog)
            }
            catch(err){res.status(400).send(err);}
        }
    );
    app.post('/api/users',requireLogin,
        async (req,res)=>{
            const {userId,displayName} = req.body;
            const user = new User({
                userId:userId,displayName:displayName
            });
            try{await user.save(); res.send(user)}
            catch(err){res.status(400).send(err);}
        });
    app.post("/api/comments",requireLogin,
        async (req,res)=>{
            const {text,rating,blog,user} = req.body;
            const comment = new Comment({
                text:text,rating:rating,
                _user : user, _blog: blog
            });
            try{await comment.save(); res.send(comment)}
            catch(err){res.status(400).send(err);}
        });
    app.delete('/api/blogs/:id',requireLogin,
        async (req,res)=> {
            try{
                const blog = await Blog.findOneAndDelete({
                   _id: req.params.id     
                });
                if(isConnected()){
                    const blogCacheKey=`blog:/api/blogs/${req.params.id }`;
                    const listCacheKey=`blog:/api/blogs/`;
                    await invalidateCache(blogCacheKey);
                    await invalidateCache(listCacheKey);
                }
                const blogs = await Blog.find({});
                res.send({deleted_blog:blog, blogs:blogs});
            }catch(err){res.status(400).send(err)}
        }
    );

    app.get('/api/blogs-with-users',requireLogin,cacheMiddleware('blog',120),
        async (req,res)=> {
            try {
                // pipeline 
                const blogsWithUsers = await Blog.aggregate([
                  {$lookup:{  
                    from: "users",
                    localField: "_user",
                    foreignField: "_id",
                    as: "author"
                  }},  
                  {$unwind: "$author"},
                  {$project: {
                    title: 1,
                    content: 1,
                    createdAt: 1,
                    'author.displayName': 1
                  }}   
                ])
                res.send(blogsWithUsers);
            }catch(err){res.status(500).send(err)}
        }
    );
    app.get('/api/blogs/:id/with-comments',requireLogin,cacheMiddleware('blog',120),
        async (req,res)=> {
            try{
               const blogWithComments = await Blog.aggregate([
                    {$match:{_id:new mongoose.Types.ObjectId(
                        req.params.id
                    )}},
                    {$lookup:{from: 'comments',
                        localField: '_id',
                        foreignField: '_blog',
                        as: 'comments'
                    }},
                    {$lookup:{from: 'users',
                        localField: '_user',foreignField:'_id',
                        as: 'author'
                    }},
                    {$unwind: '$author'},
                    {$addFields: {
                        commentCount:{$size:'$comments'},
                        averageRating: {$avg: '$comments.rating'}
                    }}
               ]);    
               res.send(blogWithComments);
            }catch(err){
                console.log(err);
                res.status(500).send(err)}
        }
    );
}