const redis = require("redis");
const redisUrl = "redis://127.0.0.1:6379";
async function demo1_GetSet(){
    const client = redis.createClient({url:redisUrl});
    client.on('error',err=>console.log("REDIS ERROR ", err));
    await client.connect();
    console.log("Connected to REDIS");
    await client.SET("user:1:name", "user 1",{EX:5});
    const value1 = await client.GET("user:1:name");
    console.log("value 1: ", value1);
    const ttl = await client.TTL('user:1:name');
    console.log(`Remaining time in seconds : ${ttl}`);
    await new Promise(resolve => setTimeout(resolve,6000));
    const value2 = await client.GET("user:1:name");
    console.log("Value 2: ", value2);
    await client.disconnect();
}
async function demo2_HsetHget(){
    const client = redis.createClient({url:redisUrl});
    client.on('error',err=>console.log("REDIS ERROR ", err));
    await client.connect();
    console.log("Connected to REDIS");
    await client.HSET('blog:1','title','Redis Tuto');
    await client.HSET('blog:1','author','Auteur 1');
    await client.HSET('blog:1','views','100');
    const title = await client.HGET('blog:1','title');
    console.log(title);
    const allInfo = await client.HGETALL('blog:1');
    for (let field in allInfo){
        console.log(`${field}: ${allInfo[field]}`);
    }
    await client.expire("blog:1", 30);
    await client.disconnect();
}
async function main(){
    try{
        await demo1_GetSet();
        console.log("------------------")
        await demo2_HsetHget();
    }catch(error){console.log(error)}
}
main().then(()=>console.log("OK"))