//middlewares/cache.js
const redis = require("redis");
const redisUrl = "redis://127.0.0.1:6379";
const redisClient = redis.createClient({url:redisUrl});
let connected = false; 
async function connect(){
    try{
        await redisClient.connect();
        connected = true;
        console.log("CONNECTED TO REDIS");
    }catch(error){
        console.error("REDIS CONNECTION ERROR: ", error);    }
}
redisClient.on("error", (err)=>{console.log("REDIS ERROR ", err)});
connect();

function cacheMiddleware(keyPrefix, ttl=60){
    return async (req,res,next)=>{
        if(!connected){
            console.log("SKIP CACHE .... Not CONNECTED");
            return next(); 
        }
        // keyPrefix:route
        // blog:/api/blogs/1
        const cacheKey = `${keyPrefix}:${req.originalUrl}`;
        try{
            const cachedData = await redisClient.get(cacheKey);
            if(cachedData){
                console.log("CACHE HIT: ", cacheKey);
                const data = JSON.parse(cachedData);
                return res.status(200).json({data});
            }
            console.log("CACHE MISS: ", cacheKey);
            const originalSend = res.json;
            res.json = function(data){
                redisClient.set(cacheKey,JSON.stringify(data),
                {EX:ttl}).then(()=>{
                    console.log(`Cached ${cacheKey} for ${ttl}`);
                }).catch(err=>console.log(err));
                originalSend.call(this,data);
            };
            next();
        }catch(error){
            console.error("Middleware error: ", error);
            next();
        }
    }
}
async function invalidateCache(key){
    if(!connected) return;
    try{
        await redisClient.del(key);
        console.log(`Key ${key} has been deleted`);
    }catch(error){
        console.log("Cache invalidate error", error);
    }
}
module.exports = {
    isConnected: ()=> connected,
    getClient: ()=> redisClient,
    cacheMiddleware,
    invalidateCache
}