const express = require("express");
const config = require("./config/dev");
console.log(config.mongoURI);
const mongoose = require("mongoose");

require("./models/User");
require("./models/Blog");
require("./models/Comment");
mongoose.connect(config.mongoURI,{});

const app = express();
app.use(express.json()); // middleware

require("./routes/blogRoutes")(app);

// GESTION DES ROUTES INTROUVABLES
app.use(function(req,res,next){
    const err = new Error("Not Found!");
    err.status = 404;
    next(err);
});
app.use((err,req,res,next)=>{
    res.status(err.status).send(`404: NOT FOUND`);
})

app.listen(config.PORT,()=>{
    console.log(`Serveur ecoute sur port ${config.PORT}`)
})