const Influx = require("influx");
const moment = require("moment-timezone");
const client = new Influx.InfluxDB({
    database: "newsql_db", host: "localhost",
    port: 8086, 
    shema:[
        {
            measurement: "login_times",
            fields: {displayName: Influx.FieldType.STRING},
            tags: ['userId','googleId']
        }
    ]
});

module.exports = app => {
    app.get("/api/logins",(req,res)=>{
        client.query(`select * from login_times ORDER BY 
                    time DESC tz('Europe/Paris')`).then(results=>{
                        res.status(200).json(results)
                    }).catch(error=>{
                        res.status(500).send("internal error");
                    });
    });
    app.get("/api/logins/minutes",(req,res)=>{
        let timeMin = "5m";
        client.query(`SELECT COUNT(displayName) FROM login_times
            WHERE time > now() - 90m 
            GROUP BY time(${timeMin})
            ORDER BY time DESC tz('Europe/Paris')`)
        .then(results => {
            const resultsNew = results.map(result => {
                const date = moment(result.time)
                .tz('Europe/Paris');
                const dateNew = date.format("HH:mm");
                return {time: dateNew, count: result.count};
            });
            res.status(200).json(resultsNew);
        }).catch(error=>{
            res.status(500).send("Internal Error");
        })
    })
}
