const Influx = require("influx");

module.exports = async(req,res,next) => {
    const client = new Influx.InfluxDB({
        database: "newsql_db", host: "localhost",
        port: 8086, 
        shema:[
            {
                measurement: "login_times",
                fields: {displayName: Influx.FieldType.STRING},
                tags: ['userId','googleId']
            }
        ]
    });

    console.log(req.user._id);
    console.log(req.user.googleId);
    console.log(req.user.displayName);

    try {
        await client.writePoints([
            {
                measurement: "login_times",
                tags: {userId:req.user._id,
                    googleId: req.user.googleId
                },
                fields: {displayName: req.user.displayName},
                timestamp: new Date()
            }
        ])
        console.log("Ecriture avec succes")
    }catch(error){console.error("Erreur ecriture Influx")}
    next();
}