import { createRouter, createWebHistory } from 'vue-router'

import A from '@/views/A.vue'
import B from '@/views/B.vue'
import C from '@/views/C.vue'
import D from '@/views/D.vue'

const routes = [
  {
    path: '/',
    name: 'home',
    components: {}, // no component displayed
  },
  {
    path: '/niveau1',
    name: 'niveau1',
    components: {
      loc1 : A,
      loc2 : B,
      loc3 : C
    },
    children: [{
      path: 'niveau2/:param1',
      components: {
        loc4: D
      },
      props: {
        loc4: route => ({props1: route.params.param1, props2: route.query.msg})
      }
    }]
  }
]

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: routes,
})

export default router
