import { createRouter, createWebHistory } from 'vue-router'
import Home from '@/views/Home.vue'
import News from '@/views/News.vue'
import CoursAlgo from '@/views/CoursAlgo.vue'
import InfoCours from '@/views/InfoCours.vue'
import ContactAlgo from '@/views/ContactAlgo.vue'
import CoursJava from '@/views/CoursJava.vue'
import ContactJava from '@/views/ContactJava.vue'

const routes = [
  {
    path:'/home',

    components: {
      locCentral : Home,
      locUp : News,
    }
  },
  {
    path:'/cours/algo',
    components: {
      locCentral : CoursAlgo,
      locUp : InfoCours,
      locDown : ContactAlgo
    }
  },
  {
    path:'/cours/java',
    components: {
      locCentral : CoursJava,
      locUp : InfoCours,
      locDown : ContactJava
    }
  }
]

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: routes,
})

export default router
