import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;

/**
 * Created by jccharr on 01/05/2020.
 */
public  class View extends Stage{
    protected   Model model;

    protected TextField tfNote1;
    protected TextField tfNote2;
    protected TextField tfTotal;

    protected RadioButton rbPlus;
    protected RadioButton rbMoins;

    protected Button resetAll;



    public View(Model model) {
        this.model=model;
        this.setTitle("Calcul");
        initWidgets();
        addWidgetsToScene();
        this.setResizable(false);


    }

    private void initWidgets() {
        String txt;

        tfNote1 = new TextField("0.0");
        tfNote1.setPrefColumnCount(5);
        tfNote1.setAlignment(Pos.CENTER_RIGHT);

        if (model.getNote1() != 0.0) {
            txt = String.valueOf(model.getNote1());
            tfNote1.setText(txt);
        }

        tfNote2 = new TextField("0.0");
        tfNote2.setPrefColumnCount(5);
        tfNote2.setAlignment(Pos.CENTER_RIGHT);

        if (model.getNote2() != 0.0) {
            txt = String.valueOf(model.getNote2());
            tfNote2.setText(txt);
        }

        tfTotal = new TextField(""+model.calcul());
        tfTotal.setPrefColumnCount(5);
        tfTotal.setAlignment(Pos.CENTER_RIGHT);

        rbPlus = new RadioButton("+");
        rbMoins = new RadioButton("-");
        if(model.isOperation())
            rbPlus.setSelected(true);
        else
            rbMoins.setSelected(true);

        ToggleGroup group=new ToggleGroup();
        rbMoins.setToggleGroup(group);
        rbPlus.setToggleGroup(group);

        resetAll = new Button("clear");

    }

    private void addWidgetsToScene(){
        Label lbNote1 = new Label("Note 1 : ");
        Label lbNote2 = new Label("Note 2 : ");
        Label lbTotal = new Label("Total : ");

        FlowPane flow1=new FlowPane();
        flow1.setAlignment(Pos.CENTER);
        flow1.getChildren().addAll(lbNote1,tfNote1);

        FlowPane flow2=new FlowPane();
        flow2.setAlignment(Pos.CENTER);
        flow2.getChildren().addAll(lbNote2,tfNote2);

        FlowPane flow3=new FlowPane();
        flow3.setAlignment(Pos.CENTER);
        flow3.getChildren().addAll(lbTotal,tfTotal);

        FlowPane flow4=new FlowPane();
        flow4.setAlignment(Pos.CENTER);
        flow4.setHgap(15);
        flow4.getChildren().addAll(rbPlus,rbMoins);

        VBox vbox=new VBox();
        vbox.setSpacing(10);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().addAll(flow1,flow2,flow3,flow4,resetAll);

        Scene scene=new Scene(vbox,150,200);
        this.setScene(scene);
    }


    public void display() {
        this.show();
    }

    void dialogError(String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }



    public void setButtonControler(EventHandler<ActionEvent> handler) {
        rbPlus.setOnAction(handler);
        rbMoins.setOnAction(handler);
        resetAll.setOnAction(handler);
    }

    public void setTextControler(ChangeListener<String> listener) {
        tfNote1.textProperty().addListener(listener);
        tfNote2.textProperty().addListener(listener);
    }


    public void resetFields() {

        tfNote1.setText("0.0");
        tfNote2.setText("0.0");
        tfTotal.setText("0.0");
        rbPlus.setSelected(true);
    }

    public TextField getTFNote1() {
        return tfNote1;
    }

    public TextField getTFNote2() {
        return tfNote2;
    }


    public TextField getTFTotal() {
        return tfTotal;
    }

    public RadioButton getRBPlus() {
        return rbPlus;
    }

    public RadioButton getRBMoins() {
        return rbMoins;
    }

    public Button getResetAll() {
        return resetAll;
    }
}
