import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

/**
 * Created by jccharr on 01/05/2020.
 */
public class ControlText implements ChangeListener<String> {
    Model model;
    View view;
    public ControlText(Model model,View view) {
        this.model=model;
        this.view=view;
        view.setTextControler(this);
    }

    @Override
    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        double value;
        try {
            value=Double.parseDouble(newValue);
        }catch (NumberFormatException e){
            view.dialogError("Une des notes saisies n'est pas au bon format.\n" +
                             "Vous ne devez utiliser que des chiffres et \n" +
                    "éventuellement un '.' pour les notes réelles.");

            return;
        }

        if(((StringProperty) observable).equals(view.getTFNote1().textProperty()))
            model.setNote1(value);
        else
            model.setNote2(value);
        String txt = String.valueOf(model.calcul());
        view.getTFTotal().setText(txt);
    }
}
